/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.terminal.widget;

import com.aptana.core.util.EclipseUtil;
import com.aptana.terminal.connector.LocalTerminalConnector;
import com.aptana.terminal.internal.IProcessListener;
import com.aptana.terminal.internal.TerminalCloseHelper;
import com.aptana.terminal.internal.emulator.VT100TerminalControl;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tm.internal.terminal.control.ITerminalListener;
import org.eclipse.tm.internal.terminal.control.ITerminalViewControl;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalConnectorExtension;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.ui.progress.UIJob;

public class TerminalComposite
extends Composite {
    private ITerminalListener terminalListener;
    private IProcessListener processListener;
    private VT100TerminalControl fCtlTerminal;
    private List<String> inputs = new ArrayList<String>();
    private boolean connecting;

    public TerminalComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        this.fCtlTerminal = new VT100TerminalControl(this.getTerminalListener(), this, this.getTerminalConnectors());
        this.fCtlTerminal.getRootControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.fCtlTerminal.setConnector(this.fCtlTerminal.getConnectors()[0]);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TerminalComposite.this.disposeTerminal();
            }
        });
    }

    public synchronized void connect() {
        if (this.connecting) {
            return;
        }
        this.connecting = true;
        UIJob job = new UIJob("Terminal connect"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    if (TerminalState.CLOSED.equals(TerminalComposite.this.fCtlTerminal.getState()) && !TerminalComposite.this.fCtlTerminal.isDisposed()) {
                        TerminalComposite.this.fCtlTerminal.connectTerminal();
                        TerminalComposite.this.hookProcessListener();
                        TerminalComposite.this.sendInputs();
                    }
                }
                finally {
                    TerminalComposite.this.connecting = false;
                }
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)job);
        job.schedule(100L);
    }

    public void disposeTerminal() {
        if (!this.fCtlTerminal.isDisposed()) {
            this.fCtlTerminal.disposeTerminal();
        }
    }

    public void setTerminalListener(ITerminalListener terminalListener) {
        this.terminalListener = terminalListener;
    }

    public void setProcessListener(IProcessListener processListener) {
        this.processListener = processListener;
    }

    private ITerminalConnector[] getTerminalConnectors() {
        ITerminalConnector connector = TerminalConnectorExtension.makeTerminalConnector((String)"com.aptana.terminal.connector.local");
        if (connector != null) {
            connector.getInitializationErrorMessage();
        }
        return new ITerminalConnector[]{connector};
    }

    private ITerminalListener getTerminalListener() {
        return new ITerminalListener(){

            public void setTerminalTitle(String title) {
                if (TerminalComposite.this.terminalListener != null) {
                    TerminalComposite.this.terminalListener.setTerminalTitle(title);
                }
            }

            public void setState(TerminalState state) {
                if (TerminalComposite.this.terminalListener != null) {
                    TerminalComposite.this.terminalListener.setState(state);
                }
            }
        };
    }

    public void setWorkingDirectory(IPath workingDirectory) {
        LocalTerminalConnector localTerminalConnector;
        if (workingDirectory != null && (localTerminalConnector = (LocalTerminalConnector)this.fCtlTerminal.getTerminalConnector().getAdapter(LocalTerminalConnector.class)) != null) {
            localTerminalConnector.setWorkingDirectory(workingDirectory);
        }
    }

    public IPath getWorkingDirectory() {
        LocalTerminalConnector localTerminalConnector = (LocalTerminalConnector)this.fCtlTerminal.getTerminalConnector().getAdapter(LocalTerminalConnector.class);
        if (localTerminalConnector != null) {
            return localTerminalConnector.getWorkingDirectory();
        }
        return null;
    }

    public boolean canCloseTerminal() {
        LocalTerminalConnector localTerminalConnector = (LocalTerminalConnector)this.fCtlTerminal.getTerminalConnector().getAdapter(LocalTerminalConnector.class);
        if (localTerminalConnector != null) {
            return TerminalCloseHelper.canCloseTerminal((IShellProvider)new SameShellProvider((Control)this), localTerminalConnector);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendInput(String text) {
        List<String> list = this.inputs;
        synchronized (list) {
            this.inputs.add(text);
            this.sendInputs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendInputs() {
        List<String> list = this.inputs;
        synchronized (list) {
            if (!this.fCtlTerminal.isConnected()) {
                return;
            }
            while (true) {
                if (this.inputs.isEmpty()) {
                    return;
                }
                this.fCtlTerminal.pasteString(this.inputs.remove(0));
            }
        }
    }

    protected void hookProcessListener() {
        LocalTerminalConnector localTerminalConnector = (LocalTerminalConnector)this.fCtlTerminal.getTerminalConnector().getAdapter(LocalTerminalConnector.class);
        if (localTerminalConnector != null && this.processListener != null) {
            localTerminalConnector.addProcessListener(this.processListener);
        }
    }

    public Control getRootControl() {
        return this.fCtlTerminal.getRootControl();
    }

    public Control getTerminalControl() {
        return this.fCtlTerminal.getControl();
    }

    public ITerminalViewControl getTerminalViewControl() {
        return this.fCtlTerminal;
    }

    public boolean isConnected() {
        return this.fCtlTerminal.isConnected();
    }

    public void clear() {
        this.fCtlTerminal.clearTerminal();
    }

    public boolean isEmpty() {
        return this.fCtlTerminal.isEmpty();
    }

    public boolean setFocus() {
        return this.fCtlTerminal.setFocus();
    }
}

